/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import dev.lucaargolo.charta.block.BarShelfBlock;
import dev.lucaargolo.charta.block.BeerGlassBlock;
import dev.lucaargolo.charta.block.CardTableBlock;
import dev.lucaargolo.charta.block.GameChairBlock;
import dev.lucaargolo.charta.block.ModBlocks;
import dev.lucaargolo.charta.block.WineGlassBlock;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.BlockModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.BlockStateProvider;
import io.github.fabricators_of_create.porting_lib.models.generators.ConfiguredModel;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.MultiPartBlockStateBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.VariantBlockStateBuilder;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7784;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(FabricDataOutput output) {
        super((class_7784)output, "charta", ExistingFileHelper.withResourcesFromArg());
    }

    protected void registerStatesAndModels() {
        for (class_1767 color : class_1767.values()) {
            String centerClothPath = "block/" + String.valueOf(color) + "_card_table_center_cloth";
            String cornerClothPath = "block/" + String.valueOf(color) + "_card_table_corner_cloth";
            String sideClothPath = "block/" + String.valueOf(color) + "_card_table_side_cloth";
            String chairClothPath = "block/" + String.valueOf(color) + "_game_chair_cloth";
            String stoolClothPath = "block/" + String.valueOf(color) + "_bar_stool_cloth";
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(centerClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_center_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(cornerClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_corner_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(sideClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_side_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(chairClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/game_chair_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(stoolClothPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/bar_stool_cloth")))).texture("particle", this.mcLoc("block/" + String.valueOf(color) + "_wool"))).texture("cloth", this.mcLoc("block/" + String.valueOf(color) + "_wool"));
        }
        ModBlocks.CARD_TABLE_MAP.forEach((woodType, cardTable) -> {
            MultiPartBlockStateBuilder cardTableBuilder = this.getMultipartBuilder((class_2248)cardTable);
            String wood = woodType.comp_1299();
            String centerPath = "block/" + wood + "_card_table_center";
            String feetPath = "block/" + wood + "_card_table_feet";
            String cornerPath = "block/" + wood + "_card_table_corner";
            String sidePath = "block/" + wood + "_card_table_side";
            String itemPath = "item/" + wood + "_card_table";
            class_2960 logResource = this.getLogResource(wood);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(centerPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_center")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(feetPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_feet")))).texture("particle", logResource)).texture("log", logResource);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(cornerPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_corner")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(sidePath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/card_table_side")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(itemPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("item/card_table")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(centerPath), 0, null, null, null, null, null);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(feetPath), 0, null, false, false, null, null);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(feetPath), 90, null, null, false, false, null);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(feetPath), 180, null, null, null, false, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(feetPath), 270, null, false, null, null, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerPath), 0, true, false, true, true, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerPath), 90, true, false, false, true, true);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerPath), 180, true, true, false, false, true);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerPath), 270, true, true, true, false, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sidePath), 0, true, true, true, true, false);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sidePath), 90, true, false, true, true, true);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sidePath), 180, true, true, false, true, true);
            this.addDirectionPart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sidePath), 270, true, true, true, false, true);
            for (class_1767 color : class_1767.values()) {
                String centerClothPath = "block/" + String.valueOf(color) + "_card_table_center_cloth";
                String cornerClothPath = "block/" + String.valueOf(color) + "_card_table_corner_cloth";
                String sideClothPath = "block/" + String.valueOf(color) + "_card_table_side_cloth";
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(centerClothPath), 0, true, true, true, true, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerClothPath), 0, true, false, true, true, false, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerClothPath), 90, true, false, false, true, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerClothPath), 180, true, true, false, false, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(cornerClothPath), 270, true, true, true, false, false, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sideClothPath), 0, true, true, true, true, false, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sideClothPath), 90, true, false, true, true, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sideClothPath), 180, true, true, false, true, true, color);
                this.addClothCardTablePart((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)cardTableBuilder.part(), this.modLoc(sideClothPath), 270, true, true, true, false, true, color);
            }
        });
        ModBlocks.GAME_CHAIR_MAP.forEach((woodType, cardTable) -> {
            MultiPartBlockStateBuilder gameChairBuilder = this.getMultipartBuilder((class_2248)cardTable);
            String wood = woodType.comp_1299();
            String chairPath = "block/" + wood + "_game_chair";
            String itemPath = "item/" + wood + "_game_chair";
            class_2960 logResource = this.getLogResource(wood);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(chairPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/game_chair")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            ((BlockModelBuilder)this.models().getBuilder(itemPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc(chairPath)));
            int rot = 0;
            for (class_2350 d : class_2350.class_2353.field_11062) {
                ((MultiPartBlockStateBuilder.PartBuilder)gameChairBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(chairPath))).rotationY(rot).addModel()).condition((class_2769)GameChairBlock.FACING, (Comparable[])new class_2350[]{d});
                for (class_1767 color : class_1767.values()) {
                    String chairClothPath = "block/" + String.valueOf(color) + "_game_chair_cloth";
                    ((MultiPartBlockStateBuilder.PartBuilder)gameChairBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(chairClothPath))).rotationY(rot).addModel()).condition((class_2769)GameChairBlock.FACING, (Comparable[])new class_2350[]{d}).condition((class_2769)GameChairBlock.CLOTH, (Comparable[])new Boolean[]{true}).condition((class_2769)GameChairBlock.COLOR, (Comparable[])new class_1767[]{color});
                }
                rot += 90;
            }
        });
        ModBlocks.BAR_STOOL_MAP.forEach((woodType, barStool) -> {
            MultiPartBlockStateBuilder barStoolBuilder = this.getMultipartBuilder((class_2248)barStool);
            String wood = woodType.comp_1299();
            String stoolPath = "block/" + wood + "_bar_stool";
            String itemPath = "item/" + wood + "_bar_stool";
            class_2960 logResource = this.getLogResource(wood);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(stoolPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/bar_stool")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            ((BlockModelBuilder)this.models().getBuilder(itemPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc(stoolPath)));
            barStoolBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(stoolPath))).addModel();
            for (class_1767 color : class_1767.values()) {
                String stoolClothPath = "block/" + String.valueOf(color) + "_bar_stool_cloth";
                ((MultiPartBlockStateBuilder.PartBuilder)barStoolBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(stoolClothPath))).addModel()).condition((class_2769)GameChairBlock.CLOTH, (Comparable[])new Boolean[]{true}).condition((class_2769)GameChairBlock.COLOR, (Comparable[])new class_1767[]{color});
            }
        });
        ModBlocks.BAR_SHELF_MAP.forEach((woodType, barShelf) -> {
            MultiPartBlockStateBuilder barShelfBuilder = this.getMultipartBuilder((class_2248)barShelf);
            String wood = woodType.comp_1299();
            String shelfPath = "block/" + wood + "_bar_shelf";
            String shelfUpPath = "block/" + wood + "_bar_shelf_up";
            String itemPath = "item/" + wood + "_bar_shelf";
            class_2960 logResource = this.getLogResource(wood);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(shelfPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/bar_shelf")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"))).texture("log", logResource);
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(shelfUpPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/bar_shelf_up")))).texture("particle", this.mcLoc("block/" + wood + "_planks"))).texture("planks", this.mcLoc("block/" + wood + "_planks"));
            ((BlockModelBuilder)this.models().getBuilder(itemPath)).parent((ModelFile)this.models().getExistingFile(this.modLoc(shelfPath)));
            int i = 0;
            for (class_2350 d : class_2350.class_2353.field_11062) {
                ((MultiPartBlockStateBuilder.PartBuilder)barShelfBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(shelfPath))).rotationY(i * 90).addModel()).condition((class_2769)BarShelfBlock.FACING, (Comparable[])new class_2350[]{d});
                ((MultiPartBlockStateBuilder.PartBuilder)barShelfBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(shelfUpPath))).rotationY(i * 90).addModel()).condition((class_2769)BarShelfBlock.FACING, (Comparable[])new class_2350[]{d}).condition((class_2769)BarShelfBlock.UP, (Comparable[])new Boolean[]{false});
                ++i;
            }
        });
        ModBlocks.BLOCKS.entrySet().stream().filter(b -> b.getValue() instanceof BeerGlassBlock).forEach(block -> {
            VariantBlockStateBuilder beerGlassBuilder = this.getVariantBuilder((class_2248)block.getValue());
            int i = 0;
            for (class_2350 d : List.of(class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11043)) {
                beerGlassBuilder.partialState().with((class_2769)BeerGlassBlock.FACING, (Comparable)d).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + ((class_2960)block.getKey()).method_12832()))).rotationY(i++ * 90).addModel();
            }
        });
        ModBlocks.BLOCKS.entrySet().stream().filter(b -> b.getValue() instanceof WineGlassBlock).forEach(block -> {
            VariantBlockStateBuilder wineGlassBuilder = this.getVariantBuilder((class_2248)block.getValue());
            wineGlassBuilder.partialState().modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + ((class_2960)block.getKey()).method_12832()))).addModel();
        });
    }

    private void addClothCardTablePart(ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> builder, class_2960 modelPath, int rotationY, Boolean valid, Boolean north, Boolean east, Boolean south, Boolean west, class_1767 color) {
        MultiPartBlockStateBuilder.PartBuilder model = this.addDirectionPart(builder, modelPath, rotationY, valid, north, east, south, west);
        model.condition((class_2769)CardTableBlock.CLOTH, (Comparable[])new Boolean[]{true});
        model.condition(CardTableBlock.COLOR, (Comparable[])new class_1767[]{color});
    }

    private MultiPartBlockStateBuilder.PartBuilder addDirectionPart(ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> builder, class_2960 modelPath, int rotationY, Boolean valid, Boolean north, Boolean east, Boolean south, Boolean west) {
        builder.modelFile((ModelFile)this.models().getExistingFile(modelPath));
        builder.rotationY(rotationY);
        MultiPartBlockStateBuilder.PartBuilder model = (MultiPartBlockStateBuilder.PartBuilder)builder.addModel();
        if (valid != null) {
            model.condition((class_2769)CardTableBlock.VALID, (Comparable[])new Boolean[]{valid});
        }
        if (north != null) {
            model.condition((class_2769)CardTableBlock.NORTH, (Comparable[])new Boolean[]{north});
        }
        if (east != null) {
            model.condition((class_2769)CardTableBlock.EAST, (Comparable[])new Boolean[]{east});
        }
        if (south != null) {
            model.condition((class_2769)CardTableBlock.SOUTH, (Comparable[])new Boolean[]{south});
        }
        if (west != null) {
            model.condition((class_2769)CardTableBlock.WEST, (Comparable[])new Boolean[]{west});
        }
        return model;
    }

    private class_2960 getLogResource(String wood) {
        class_2960 logResource = this.mcLoc("block/" + wood + "_log");
        if (!this.models().existingFileHelper.exists(this.mcLoc("textures/block/" + wood + "_log.png"), class_3264.field_14188)) {
            logResource = this.mcLoc("block/" + wood + "_stem");
            if (!this.models().existingFileHelper.exists(this.mcLoc("textures/block/" + wood + "_stem.png"), class_3264.field_14188)) {
                logResource = this.mcLoc("block/" + wood + "_stalk");
            }
        }
        return logResource;
    }
}

